%% PLOTTING I-TO-F CONVERTER CHARACTERISTICS

%%
clc;
clear all;
close all;

% Parameters
C = 50e-15;         % Integrating capacitor [F]
I = 20e-6;          % Input current [A]
V_comp = 1;         % Comparator threshold voltage [V]
Vcc = 3;            % Power supply voltage of the comparator [V]
t_d = 1e-9;         % Delay time [s]


% Variables
dt = 0.001e-9;
tmax = 125e-9;
t = 0:dt:tmax; % Time Vector (seconds)

Vc_id = zeros(size(t));         % Capacitor voltage vector [V]
Vout_id = zeros(size(t));       % Comparator output vector [V]
fout_id = zeros(size(t));       % Output frequency [Hz]

Vc_dly = zeros(size(t)); % Capacitor Voltage Vector (volts)
Vout_dly = zeros(size(t)); % Comparator Output Vector (volts)


% Simulation
for i = 2:length(t)
    % Capacitor Charge (ideal case)
    Vc_id(i) = Vc_id(i-1) + ((I/C)*dt);
    
    % Comparator Output
    if Vc_id(i) >= V_comp
        Vout_id(i) = Vcc; % MOSFET ON (Capacitor Discharge)
        Vc_id(i) = 0;
    else
        Vout_id(i) = 0; % MOSFET OFF (Capacitor Charge)
    end

end

% Convert the spike train signal into a binary vector
spike_binary = Vout_id > 1;

% Compute the inter-spike intervals
spike_times = t(spike_binary);
ISIs = diff(spike_times);

% Compute the instantaneous frequency
inst_freq = 1./ISIs;



% Plot Results
figure(1);
subplot(3,1,1);
plot(t,Vc_id);
xlabel('Time (s)');
ylabel('Capacitor Voltage (V)');
title('Capacitor Charge with Constant Current');

subplot(3,1,2);
plot(t,Vout_id);
xlabel('Time (s)');
ylabel('Comparator Output (V)');
title('Comparator Output to MOSFET Switch');

% Plot the instantaneous frequency
figure(2);
plot(spike_times(1:end-1), inst_freq);
xlabel('Time (s)');
ylabel('Instantaneous frequency (Hz)');


% % Define a time vector
% t = 0:0.01:10;
% 
% % Generate a sample spike train signal
% spike_train = sin(2*pi*t) + randn(size(t));
% 
% % Convert the spike train signal into a binary vector
% spike_binary = spike_train > 1;
% 
% % Compute the inter-spike intervals
% spike_times = t(spike_binary);
% ISIs = diff(spike_times);
% 
% % Compute the instantaneous frequency
% inst_freq = 1./ISIs;
% 
% % Plot the instantaneous frequency
% plot(spike_times(1:end-1), inst_freq);
% xlabel('Time (s)');
% ylabel('Instantaneous frequency (Hz)');
% 
